'Version 2.0 May 2015 Taken over WIA repeater file creation
'Version 1.5 Dec 2013 Created LongLat Merge Version and improved handling of Notes
'Version 1.4 Sept 2013 Callsign filtering bug. 1 call area filter now works
'WiaRep2UV6DCommander created Sept 2013
'Version 1.3 Feb 2013 Script now ignores blank lines
'Version 1.2 July 2012 Added the /f filter to limit output to a list of states
'Version 1.1 June 2012 Fixed mismatched header columns and repeater columns, Added other sections
'Version 1.0 March 2012 - Original
'Copyright (c) Steve Ireland 2012
'WiaRep2UV6DCommander.vbs and all other variants that start with WiaRep2 were originaly written by Steve Ireland VK2MD (vk2md@wia.org.au)
'This application can be freely distributed, modified and used by anybody for both private and commercial purposes.

'If you make changes to the software please add the statements above to your source code to achnowledge Steve Ireland VK2MD as the original author and to freely 
'distribute your software.
'Please Please Please do not use the file name prefix WiaRep2 or WiaRepTo as I use this prefix on software that I maintain.
'In essance the naming convention is the only intellectual property that I assert purely for maintenance purposes.
'Have fun. Steve March 2012


'This script will read the WIA Repeater Directory CSV file and create a UV6DCommander csv file


'To run this script 
'   cscript WiaRep2UV6DCommander.vbs "Repeater Directory 120214.csv" uv6d.csv
'   use the /f option to filter on states. eg /f:vk1,vk2,vk3 will only output repeaters from the listed states

 
Option Explicit
Dim args
Const ForReading = 1, ForWriting = 2, ForAppending = 8
Main

Sub Main()
    If ParseArgs() < 2 Then
        wscript.echo "Usage: cscript WiaRep2UV6DCommander.vbs ""WIA Repeater Directory ????.csv"" uv6d.csv"
        wscript.echo "       Use option /f to filter states"
        Exit Sub
    End If


    'Go load the WIA repeater file using the passed in file name in arg0
    Dim bands
    bands = LoadWia(args("arg0"))

    'The WIA repeater csv will evolve over time so just test how big it is wrt the size it was when the script was developed
    If Not (UBound(bands) = 34 or UBound(bands) = 42) Then
        wscript.echo "Warning. The number of band sections in the WIA script has changed."
        wscript.echo "The script will try to continue but may miss out the extra data or crash."
    End If

    SaveUV6D args("arg1"), bands

End Sub

'parses the arguments passed in and places them in a global dictionary for easy access
Function ParseArgs
    Dim namelessCount
    namelessCount = 0
    set args = CreateObject("Scripting.Dictionary") 'args are global

    Dim i
    For i=0 to WScript.Arguments.Count - 1
        Dim arg
        arg = WScript.Arguments.Item(i)
        If Left(arg,1) = "/" Or Left(arg,1) = "-" Then
            arg = Replace(arg,"/","")
            arg = Replace(arg,"-","")
            arg = Trim(arg)
            Dim parts
            parts = Split(arg,":")
            If UBound(parts) = 0 Then
                args.Add parts(0),""
            Else
                args.Add parts(0),parts(1)
            End If
        Else
            args.Add "arg" & CStr(namelessCount),arg
            namelessCount = namelessCount + 1
        End If
    Next

    ParseArgs = WScript.Arguments.Count
End Function

'Load the WIA CSV file into memory
'Returns a list of bands, that contains a list of repeaters. Each repeater entry is a dictionary
' eg bands(3)(32)("Call") will go to section 3, repeater number 32 and retrieve the Call entry as a string. Cool!
Function LoadWia(sourceCSV)
    Dim bands()
    LoadWia = bands

    Dim fso 
    set fso = CreateObject("Scripting.FileSystemObject")

    Dim file
    Set file = fso.OpenTextFile(sourceCSV, ForReading)
    If file.AtEndOfStream Then
        Exit Function
    End If

    'read in the header and get rid of all those extra quotes
    Dim header
    Dim i
    header = Split(Trim(Replace(file.ReadLine,"""","")),",") 
    For i=0 To UBound(header)
       header(i) = Trim(header(i)) 'Another Trim as one of the headers has an extra space at the end :-)
    Next

    'test that it is a WIA repeater file
    If header(0) <> "Output" And header(1) <> "Input" And header(2) <> "Call" Then
        wscript.echo sourceCSV & " is not a WIA repeater CSV file"
        Exit Function
    End If

    'read first line as it is a band seperator with commas everywhere and gives band information
    Dim bandSeparator
    bandSeparator = Split(Trim(Replace(file.ReadLine,"""","")),",")

    'load up every band
    Dim numBands
    numBands=0
    Do While file.AtEndOfStream <> True
        Dim band
        band = LoadWiaBand(file, header, bandSeparator)
        ReDim Preserve bands(numBands) 'expand the list
        bands(numBands) = band
        numBands = numBands + 1
    Loop
    file.Close

    LoadWia = bands 'return the whole structure
End Function


Function LoadWiaBand(file, header, bandSeparator)
    Dim repeater
    Dim repeaterDict
    Dim numRepeaters
    Dim band()

    numRepeaters = 0
    Do While file.AtEndOfStream <> True
        repeater = Split(Trim(Replace(file.ReadLine,"""","")),",") 'read in a repeater line from the file and split on a ,
        If UBound(repeater) > 2 Then 'skip illegal lines

            Dim i
            For i=0 To UBound(repeater) 'Trim up every field
               repeater(i) = Trim(repeater(i))
            Next
            'each band is seperated by and empty row
            If repeater(0) = "" And repeater(1) ="" And repeater(2) = "" Then
                bandSeparator = repeater
                LoadWiaBand = band
                Exit Function
            End If

            'create a repeater dictionary for each row keyed on the header
            set repeaterDict = CreateObject("Scripting.Dictionary")
            For i=0 to UBound(header)
                If i <= UBound(repeater) Then
                    If i < UBound(header) Then
                        repeaterDict.Add header(i), repeater(i) 
                    Else 'The note field can have extra , so we need to recombine them
                        Dim noteLine
                        noteLine = ""
                        Dim j
                        For j=i to UBound(repeater)
                            noteLine = noteLine & repeater(j) & ","
                        Next
                        noteLine = Left(noteLine,Len(noteLine)-1)
                        repeaterDict.Add header(i), noteLine 
                    End If
                Else
                    printMismatch(header)
                    printMismatch(repeater)
                    wscript.echo "Repeater has incorrect number of columms compared to header and has been skipped"
                    wscript.echo
                End If
            Next

            repeaterDict.Add "Tag",bandSeparator(14)
                
            'Into the band list goes the repeater dictionary
            ReDim Preserve band(numRepeaters)
            set band(numRepeaters) = RepeaterDict
            numRepeaters = numRepeaters + 1
        End If
    Loop
    LoadWiaBand = band
End Function

Sub printMismatch(entry)
    Dim Line
    Line = ""
    Dim i
    For i=0 to UBound(entry)
        Line = Line & entry(i) & ", "
    Next
    wscript.echo Line
End Sub



Sub SaveUV6D(filename, bands)
    Dim loc
    loc = 0

    Dim fso 
    set fso = CreateObject("Scripting.FileSystemObject")
    Dim file

    'Delete the old file (if it exists) and create a new
    On Error Resume Next
    fso.DeleteFile(filename)
    On Error goto 0
    Set file = fso.CreateTextFile(filename)

    wscript.echo "Created File " & filename

    'Write the header and save
    WriteUV6DHeader file

    loc = SaveUV6DVHF(file, loc, bands)
    loc = SaveUV6DUHF(file, loc, bands)

    file.Close()
    wscript.echo
    wscript.echo CStr(loc+1) & " repeaters processed"

End Sub


Function SaveUV6DVHF(file, loc, bands)

    wscript.echo
    wscript.echo "Generating VHF Entries"

    const bandStart = 7 'vhfbands are 7 to 13 when this was written. It may change!
    const bandEnd = 13
    const callSuffix = "2"

    SaveUV6DVHF = SaveUV6DFM(file, loc, bands, bandStart, bandEnd, callSuffix)

End Function

Function SaveUV6DUHF(file, loc, bands)
    wscript.echo
    wscript.echo "Generating UHF Entries"

    const bandStart = 14 'uhfbands are 14 to 20 when this was written. It may change!
    const bandEnd = 20
    const callSuffix = "7"

    SaveUV6DUHF = SaveUV6DFM(file, loc, bands, bandStart, bandEnd, callSuffix)

End Function



Function SaveUV6DFM(file, loc, bands, loopStart, loopEnd, callSuffix)

    'uninitialised locals
    Dim Line
    Dim i
    For i=loopStart to loopEnd 
        Dim repeater
        For Each repeater in bands(i)

            If RepeaterCallsignInFilter(repeater) = True Then

                'test to make sure that input and output frequencies are within the radios range, otherwise skip
                'There is a 10m repeater with a 2m output freq
                If (    ((CDbl(repeater("Output")) >= 144.0 And CDbl(repeater("Output")) < 148.0) Or (CDbl(repeater("Output")) >= 420.0 And CDbl(repeater("Output")) < 450.0) ) And _
                        ((CDbl(repeater("Input")) >= 144.0 And CDbl(repeater("Input")) < 148.0) Or (CDbl(repeater("Input")) >= 420.0 And CDbl(repeater("Input")) < 450.0) ) _
                   ) Then

                    'write each field into a string
                    Line = WriteUV6DName(repeater("Call"),callSuffix)
                    Line = Line & WriteUV6DFrequency(repeater("Output"))
                    Line = Line & WriteUV6DFrequency(repeater("Input"))
                    Line = Line & WriteUV6DDecode()
                    Line = Line & WriteUV6DEncode(repeater("Tone"))
                    Line = Line & WriteUV6DPower()
                    Line = Line & WriteUV6DScan()
                    Line = Line & WriteUV6DDeviation()
                    Line = Line & WriteUV6DBusyLock()
                    Line = Line & WriteUV6DGroupNotes(repeater("Service Area"))
                    'Write to the file
                    file.WriteLine(Line)
                    Wscript.StdOut.Write "."
                    loc = loc + 1
                End If
            End If
        Next
    Next

    SaveUV6DFM = loc

End Function

Function RepeaterCallsignInFilter(repeater)
     If Not args.Exists("f") Then 
         RepeaterCallsignInFilter = True
         Exit Function
     End If

    Dim parts
    parts = Split(args("f"),",")
    If UBound(parts) = -1 Then
         RepeaterCallsignInFilter = True
         Exit Function
    End If

    Dim i
    For i=0 to UBound(parts)
        If InStr(UCase(repeater("Call")),UCase(parts(i))) <> 0 Then
            RepeaterCallsignInFilter = True
            Exit Function
        End If
    Next

    RepeaterCallsignInFilter = False

End Function


'UV6D Support files
'They create the UV6D fields by converting the WIA fields

Sub WriteUV6DHeader(file)
   file.WriteLine("Name,Rx Freq,Tx Freq,Decode,Encode,TX Pwr,Scan,TX Dev,Busy Lck,Group/Notes")
End Sub

Function WriteUV6DLocation(loc)
    WriteUV6DLocation = CStr(loc) & ","
End Function

'You shorten the call sign by removing the first 2 letters (vk) and append the suffix
Function WriteUV6DName(callsign, suffix)
    WriteUV6DName = Right(callsign, Len(callsign) - 2)
    If suffix = "" Then 'do nothing case
        WriteUV6DName = WriteUV6DName & ","
        Exit Function
    End if
    WriteUV6DName = WriteUV6DName & " " & suffix & ","
End Function

Function WriteUV6DFrequency(freq)
    WriteUV6DFrequency = FormatNumber(CSng(freq),3,vbTrue,vbFalse,vbFalse) & ","
End Function

Function WriteUV6DDecode()
    WriteUV6DDecode =  "OFF,"
End Function

Function WriteUV6DEncode(tone)
    If tone = "-" Or tone = " " Or tone ="" Then 'tone is a little variable in the wia csv file
        WriteUV6DEncode = "OFF,"
    Else
        WriteUV6DEncode = FormatNumber(CSng(tone),1,vbTrue,vbFalse,vbFalse) & "," 'Looks like Tone must always have 1 character after the decimal point
    End If
End Function

Function WriteUV6DPower()
    WriteUV6DPower =  "HIGH,"
End Function

Function WriteUV6DScan()
    WriteUV6DScan =  "ON,"
End Function

Function WriteUV6DDeviation()
    WriteUV6DDeviation =  "Wide,"
End Function

Function WriteUV6DBusyLock()
    WriteUV6DBusyLock =  "OFF,"
End Function

Function WriteUV6DGroupNotes(note)
    WriteUV6DGroupNotes = note 'Last field aways, so no comma
End Function
